require 'base'
require 'watir-webdriver'
require 'page-object'


class Landing < Base
  include PageObject

  def initialize(driver)
    @driver = driver
    super(driver)
  end

  expected_title "VA Tool Set"

  #Unauthenticated landing page
  button(:login, :css => '.login')

  #pre-authorized landing page
  div(:welcome_message, :css=>'.institution-page-wrapper.manage-settings-content.ng-scope')

  #authorized landing page
  div(:new_welcome_message, :css=>'.home-page')
  
  #unauthorized landing page
  div(:unauthorized_welcome_message, :css=> '.welcome')

  #footerUserInfo
  element(:footerUserInfo, :span, :css=>'.ng-scope span.ng-scope')

  #view settings button
  button(:view_settings, :id=>'open-settings-btn')

  #Select a Facility location drop down
  select_list(:facility_location, :id=>'institution-select')

  def selectFaciltyLocation(facility)
    list_items = facility_location.options
    list_items[facility].click

  end
  

end

